//
//  B5DocumentDataOperation+progress.h
//  
//
//  Created by Chad Seldomridge on 9/22/15.
//
//

#import <Foundation/Foundation.h>
#import "B5DocumentDataOperation.h"

@interface B5DocumentDataOperation (progress)

// These methods provide registration and lookup of document monitors by monitor identifier
+ (void)addDocumentDataMonitorToProgressCenter:(id<OPDataOperationMonitor>)monitor;
+ (id<OPDataOperationMonitor>)documentDataMonitorForIdentifierInProgressCenter:(NSString *)identifier;
+ (void)removeDocumentDataMonitorWithIdentifierFromProgressCenter:(NSString *)identifier;

// These methods provide notification center like progress publishing
+ (void)postDocumentDataMonitorProgressForMonitorIdentifier:(NSString *)identifier percentage:(float)percentage activeStep:(NSUInteger)activeStep stepCount:(NSUInteger)stepCount;
+ (id<NSObject>)addProgressObserverForMonitorIdentifier:(NSString *)identifier usingBlock:(void (^)(NSString *monitorIdentifier, float percentage, NSUInteger activeStep, NSUInteger stepCount))progressBlock;
+ (void)removeProgressObserver:(id<NSObject>)observer;

+ (void)postDocumentDataMonitorCompletionForMonitorIdentifier:(NSString *)identifier;
+ (id<NSObject>)addCompletionObserverForMonitorIdentifier:(NSString *)identifier usingBlock:(void (^)(NSString *monitorIdentifier))completionBlock;
+ (void)removeCompletionObserver:(id<NSObject>)observer;

@end
